/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TurfWarControlEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.PlayerList;

class TurfWarTriggeredAbility
extends TriggeredAbilityImpl {
    public TurfWarTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TurfWarControlEffect());
        this.setTriggerPhrase("Whenever a creature deals combat damage to a player, if that player controls one or more lands with contested counters on them, ");
    }

    private TurfWarTriggeredAbility(TurfWarTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TurfWarTriggeredAbility copy() {
        return new TurfWarTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        if (!damageEvent.isCombatDamage()) {
            return false;
        }
        UUID creatureId = damageEvent.getSourceId();
        Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
        if (creature == null) {
            return false;
        }
        UUID playerId = damageEvent.getPlayerId();
        PlayerList inRange = game.getState().getPlayersInRange(this.controllerId, game);
        if (!inRange.contains((Object)playerId) || !inRange.contains((Object)creature.getControllerId())) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, playerId, game)) {
            if (permanent.getCounters(game).getCount(CounterType.CONTESTED) <= 0) continue;
            this.getEffects().setValue("creature", (Object)creatureId);
            this.getEffects().setValue("player", (Object)playerId);
            return true;
        }
        return false;
    }
}

