/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.token.PlantToken;
import mage.game.permanent.token.Token;

class TurntimberSowerTriggeredAbility
extends TriggeredAbilityImpl {
    public TurntimberSowerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new PlantToken()), false);
    }

    private TurntimberSowerTriggeredAbility(TurntimberSowerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.GRAVEYARD == zEvent.getToZone() && zEvent.getCards() != null) {
            for (Card card : zEvent.getCards()) {
                UUID cardOwnerId;
                if (card == null || (cardOwnerId = card.getOwnerId()) == null || !card.isOwnedBy(this.getControllerId()) || !card.isLand(game)) continue;
                return true;
            }
        }
        return false;
    }

    public TurntimberSowerTriggeredAbility copy() {
        return new TurntimberSowerTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more land cards are put into your graveyard from anywhere, create a 0/1 green Plant creature token.";
    }
}

