/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TwilightProphetEffect
extends OneShotEffect {
    TwilightProphetEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library and put it into your hand. Each opponent loses X life and you gain X life, where X is that card's mana value.";
    }

    private TwilightProphetEffect(TwilightProphetEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwilightProphetEffect copy() {
        return new TwilightProphetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
                controller.moveCards(card, Zone.HAND, source, game);
                game.processAction();
                int amount = card.getManaValue();
                if (amount > 0) {
                    new LoseLifeOpponentsEffect(amount).apply(game, source);
                    controller.gainLife(amount, game, source);
                }
            }
            return true;
        }
        return false;
    }
}

