/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TwilightsCallEffect
extends OneShotEffect {
    TwilightsCallEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player returns all creature cards from their graveyard to the battlefield";
    }

    private TwilightsCallEffect(TwilightsCallEffect copy) {
        super((OneShotEffect)copy);
    }

    public TwilightsCallEffect copy() {
        return new TwilightsCallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet toBattlefield = new HashSet();
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                toBattlefield.addAll(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

