/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TwinflameCopyEffect
extends OneShotEffect {
    TwinflameCopyEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "choose any number of target creatures you control. For each of them, create a token that's a copy of that creature, except it has haste. Exile those tokens at the beginning of the next end step";
    }

    private TwinflameCopyEffect(TwinflameCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwinflameCopyEffect copy() {
        return new TwinflameCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList toExile = new ArrayList();
        for (UUID creatureId : this.getTargetPointer().getTargets(game, source)) {
            Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
            if (creature == null) continue;
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            effect.apply(game, source);
            toExile.addAll(effect.getAddedPermanents());
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ExileTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(toExile, game))), source);
        return true;
    }
}

