/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class TwistedJusticeEffect
extends OneShotEffect {
    TwistedJusticeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices a creature. You draw cards equal to that creature's power";
    }

    private TwistedJusticeEffect(TwistedJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getTargets().getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (target.canChoose(player.getId(), source, game)) {
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.sacrifice(source, game);
                controller.drawCards(permanent.getPower().getValue(), source, game);
            }
            return true;
        }
        return false;
    }

    public TwistedJusticeEffect copy() {
        return new TwistedJusticeEffect(this);
    }
}

