/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;
import mage.target.Target;

class TymaretChosenFromDeathEffect
extends OneShotEffect {
    TymaretChosenFromDeathEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to two target cards from graveyards. You gain 1 life for each creature card exiled this way";
    }

    private TymaretChosenFromDeathEffect(TymaretChosenFromDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public TymaretChosenFromDeathEffect copy() {
        return new TymaretChosenFromDeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toSet()));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        int lifeGain = cards.getCards(game).stream().filter(card -> card.isCreature(game)).map(MageItem::getId).map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).filter(arg_0 -> Zone.EXILED.equals(arg_0)).mapToInt(x -> 1).sum();
        if (lifeGain > 0) {
            game.processAction();
            player.gainLife(lifeGain, game, source);
        }
        return true;
    }
}

