/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.RandomUtil;

class TyrantOfDiscordEffect
extends OneShotEffect {
    TyrantOfDiscordEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent chooses a permanent they control at random and sacrifices it. If a nonland permanent is sacrificed this way, repeat this process";
    }

    private TyrantOfDiscordEffect(TyrantOfDiscordEffect effect) {
        super((OneShotEffect)effect);
    }

    public TyrantOfDiscordEffect copy() {
        return new TyrantOfDiscordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID target = source.getFirstTarget();
        Player opponent = game.getPlayer(target);
        if (opponent != null) {
            boolean stop = false;
            block0: while (!stop) {
                int count = game.getBattlefield().countAll(new FilterPermanent(), opponent.getId(), game);
                if (count > 0) {
                    int random = (int)(RandomUtil.nextDouble() * (double)count);
                    int index = 0;
                    for (Permanent permanent : game.getBattlefield().getAllActivePermanents(opponent.getId())) {
                        if (index == random) {
                            if (permanent.sacrifice(source, game)) {
                                if (permanent.isLand(game)) {
                                    stop = true;
                                    game.informPlayers("Land permanent has been sacrificed: " + permanent.getName() + ". Stopping process.");
                                    continue block0;
                                }
                                game.informPlayers("Nonland permanent has been sacrificed: " + permanent.getName() + ". Repeating process.");
                                continue block0;
                            }
                            game.informPlayers("Couldn't sacrifice a permanent. Stopping the process.");
                            stop = true;
                            continue block0;
                        }
                        ++index;
                    }
                    continue;
                }
                game.informPlayers("There is no permanent to sacrifice");
                stop = true;
            }
        }
        return true;
    }
}

