/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class PlayCreatureLandWatcher
extends Watcher {
    private final Set<UUID> playerPlayedLand = new HashSet<UUID>();
    private final Set<UUID> landPlayed = new HashSet<UUID>();

    public PlayCreatureLandWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Card card;
        if (event.getType() == GameEvent.EventType.PLAY_LAND && (card = game.getCard(event.getTargetId())) != null && card.isLand(game) && card.isCreature(game) && !this.playerPlayedLand.contains(event.getPlayerId())) {
            this.playerPlayedLand.add(event.getPlayerId());
            this.landPlayed.add(event.getTargetId());
        }
    }

    public void reset() {
        this.playerPlayedLand.clear();
        this.landPlayed.clear();
        super.reset();
    }

    public boolean landPlayed(UUID playerId) {
        return this.playerPlayedLand.contains(playerId);
    }

    public boolean wasLandPlayed(UUID landId) {
        return this.landPlayed.contains(landId);
    }
}

