/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.u.UbaMaskExiledCardsWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class UbaMaskReplacementEffect
extends ReplacementEffectImpl {
    UbaMaskReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a player would draw a card, that player exiles that card face up instead";
    }

    private UbaMaskReplacementEffect(UbaMaskReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public UbaMaskReplacementEffect copy() {
        return new UbaMaskReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        MageObject sourceObject = source.getSourceObject(game);
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null && sourceObject != null && (card = player.getLibrary().getFromTop(game)) != null) {
            UbaMaskExiledCardsWatcher watcher;
            UUID exileId = CardUtil.getExileZoneId((String)(player.getId().toString() + "-" + game.getState().getTurnNum() + "-" + sourceObject.getIdName() + "-" + sourceObject.getZoneChangeCounter(game)), (Game)game);
            String exileName = sourceObject.getIdName() + " play on turn " + game.getState().getTurnNum() + " for " + player.getName();
            game.getExile().createZone(exileId, exileName).setCleanupOnEndTurn(true);
            if (player.moveCardsToExile(card, source, game, true, exileId, exileName) && (watcher = (UbaMaskExiledCardsWatcher)game.getState().getWatcher(UbaMaskExiledCardsWatcher.class)) != null) {
                watcher.addExiledCard(event.getPlayerId(), card, game);
            }
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }
}

