/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UginTheIneffableDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<MageObjectReference> tokenRefs;
    private final MageObjectReference cardRef;

    UginTheIneffableDelayedTriggeredAbility(Set<MageObjectReference> tokens, MageObjectReference card) {
        super(null, Duration.Custom, true);
        this.tokenRefs = tokens;
        this.cardRef = card;
    }

    private UginTheIneffableDelayedTriggeredAbility(UginTheIneffableDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.tokenRefs = ability.tokenRefs;
        this.cardRef = ability.cardRef;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.BATTLEFIELD || this.tokenRefs.stream().noneMatch(tokenRef -> tokenRef.refersTo((MageObject)zEvent.getTarget(), game))) {
            return false;
        }
        this.getEffects().clear();
        ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(this.cardRef));
        this.addEffect((Effect)effect);
        return true;
    }

    public UginTheIneffableDelayedTriggeredAbility copy() {
        return new UginTheIneffableDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When this token leaves the battlefield, put the exiled card into your hand.";
    }
}

