/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.Card;
import mage.cards.u.UginTheIneffableDelayedTriggeredAbility;
import mage.cards.u.UginTheIneffableLookAtFaceDownEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.UginTheIneffableToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class UginTheIneffableEffect
extends OneShotEffect {
    UginTheIneffableEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library face down and look at it. Create a 2/2 colorless Spirit creature token. When that token leaves the battlefield, put the exiled card into your hand.";
    }

    private UginTheIneffableEffect(UginTheIneffableEffect effect) {
        super((OneShotEffect)effect);
    }

    public UginTheIneffableEffect copy() {
        return new UginTheIneffableEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        if (player.moveCardsToExile(card, source, game, false, exileZoneId, sourceObject.getIdName() + " (" + player.getName() + ")")) {
            card.turnFaceDown(source, game, source.getControllerId());
            player.lookAtCards(player.getName() + " - " + card.getIdName() + " - " + CardUtil.sdf.format(System.currentTimeMillis()), card, game);
        }
        HashSet<MageObjectReference> tokenObjs = new HashSet<MageObjectReference>();
        CreateTokenEffect effect = new CreateTokenEffect((Token)new UginTheIneffableToken());
        effect.apply(game, source);
        for (UUID addedTokenId : effect.getLastAddedTokenIds()) {
            SimpleStaticAbility sa = new SimpleStaticAbility((Effect)new InfoEffect("Referenced object: " + card.getId().toString().substring(0, 3)));
            GainAbilityTargetEffect gainAbilityEffect = new GainAbilityTargetEffect((Ability)sa, Duration.WhileOnBattlefield);
            gainAbilityEffect.setTargetPointer((TargetPointer)new FixedTarget(addedTokenId));
            game.addEffect((ContinuousEffect)gainAbilityEffect, source);
            UginTheIneffableLookAtFaceDownEffect lookAtEffect = new UginTheIneffableLookAtFaceDownEffect();
            lookAtEffect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            game.addEffect((ContinuousEffect)lookAtEffect, source);
            tokenObjs.add(new MageObjectReference(addedTokenId, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new UginTheIneffableDelayedTriggeredAbility(tokenObjs, new MageObjectReference((MageObject)card, game)), source);
        }
        return true;
    }
}

