/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class UginTheSpiritDragonEffect2
extends OneShotEffect {
    public UginTheSpiritDragonEffect2() {
        super(Outcome.Exile);
        this.staticText = "exile each permanent with mana value X or less that's one or more colors";
    }

    private UginTheSpiritDragonEffect2(UginTheSpiritDragonEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public UginTheSpiritDragonEffect2 copy() {
        return new UginTheSpiritDragonEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int cmc = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterPermanent filter = new FilterPermanent("permanent with mana value X or less that's one or more colors");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, cmc + 1));
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
        HashSet permanentsToExile = new HashSet();
        permanentsToExile.addAll(game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game));
        controller.moveCards(permanentsToExile, Zone.EXILED, source, game);
        return true;
    }
}

