/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.ReturnToHandFromBattlefieldAllEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.keyword.DevoidAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class UginsBinding
extends CardImpl {
    private static final FilterPermanent filter = new FilterNonlandPermanent("nonland permanent you don't control");
    private static final FilterSpell filter2 = new FilterSpell("a colorless spell with mana value 7 or greater");

    public UginsBinding(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{U}");
        this.addAbility((Ability)new DevoidAbility(this.color));
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)new SpellCastControllerTriggeredAbility(Zone.GRAVEYARD, (Effect)new DoWhenCostPaid(new ReflexiveTriggeredAbility((Effect)new ReturnToHandFromBattlefieldAllEffect(filter).setText("return each nonland permanent you don't control to its owner's hand"), false), (Cost)new ExileSourceFromGraveCost(), "Exile this from your graveyard?"), filter2, false, SetTargetPointer.NONE));
    }

    private UginsBinding(UginsBinding card) {
        super((CardImpl)card);
    }

    public UginsBinding copy() {
        return new UginsBinding(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filter2.add((Predicate)ColorlessPredicate.instance);
        filter2.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 6));
    }
}

