/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class UginsLabyrinthExileEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a colorless card with mana value 7 or greater");

    UginsLabyrinthExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile a colorless card with mana value 7 or greater from your hand";
    }

    private UginsLabyrinthExileEffect(UginsLabyrinthExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public UginsLabyrinthExileEffect copy() {
        return new UginsLabyrinthExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 6));
    }
}

