/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.u.UginsMasteryEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class UginsMasteryTriggeredAbility
extends TriggeredAbilityImpl {
    UginsMasteryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new UginsMasteryEffect());
        this.setTriggerPhrase("Whenever you attack with creatures with total power 6 or greater, ");
    }

    private UginsMasteryTriggeredAbility(UginsMasteryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UginsMasteryTriggeredAbility copy() {
        return new UginsMasteryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) return false;
        if (game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).sum() < 6) return false;
        return true;
    }
}

