/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.turn.AddExtraTurnControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class UginsNexusExileEffect
extends ReplacementEffectImpl {
    UginsNexusExileEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If {this} would be put into a graveyard from the battlefield, instead exile it and take an extra turn after this one";
    }

    private UginsNexusExileEffect(UginsNexusExileEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public UginsNexusExileEffect copy() {
        return new UginsNexusExileEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        if (permanent != null) {
            permanent.moveToExile(null, "", source, game);
            new AddExtraTurnControllerEffect().apply(game, source);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent;
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(source.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && zEvent.getFromZone() == Zone.BATTLEFIELD;
    }
}

