/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UglukOfTheWhiteHandEffect
extends OneShotEffect {
    private static final FilterPermanent filterOrcOrGoblin = new FilterCreaturePermanent();

    public UglukOfTheWhiteHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on {this}. If that creature was a Goblin or Orc, put two +1/+1 counters on {this} instead.";
    }

    private UglukOfTheWhiteHandEffect(UglukOfTheWhiteHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public UglukOfTheWhiteHandEffect copy() {
        return new UglukOfTheWhiteHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent ugluk;
        Permanent deadCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        boolean wasOrcOrGoblin = false;
        if (deadCreature != null) {
            wasOrcOrGoblin = filterOrcOrGoblin.match((Object)deadCreature, game);
        }
        if ((ugluk = game.getPermanent(source.getSourceId())) == null) {
            return false;
        }
        ugluk.addCounters(CounterType.P1P1.createInstance(wasOrcOrGoblin ? 2 : 1), source.getControllerId(), source, game);
        return true;
    }

    static {
        filterOrcOrGoblin.add(Predicates.or((Predicate)SubType.ORC.getPredicate(), (Predicate)SubType.GOBLIN.getPredicate()));
    }
}

