/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UlashtTheHateSeedEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filterGreen = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterRed = new FilterControlledCreaturePermanent();

    UlashtTheHateSeedEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} enters with a +1/+1 counter on it for each other red creature you control and a +1/+1 counter on it for each other green creature you control.";
    }

    private UlashtTheHateSeedEffect(UlashtTheHateSeedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && player != null) {
            int amount = game.getBattlefield().count((FilterPermanent)filterRed, source.getControllerId(), source, game);
            if ((amount += game.getBattlefield().count((FilterPermanent)filterGreen, source.getControllerId(), source, game)) > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public UlashtTheHateSeedEffect copy() {
        return new UlashtTheHateSeedEffect(this);
    }

    static {
        filterGreen.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filterGreen.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        filterRed.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filterRed.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

