/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.keyword.CompanionCondition;
import mage.cards.Card;
import mage.constants.CardType;

enum UmoriCondition implements CompanionCondition
{
    instance;


    public String getRule() {
        return "Each nonland card in your starting deck shares a card type.";
    }

    public boolean isLegal(Set<Card> deck, int minimumDeckSize) {
        HashSet cardTypes = new HashSet();
        for (Card card : deck) {
            if (card.hasCardTypeForDeckbuilding(CardType.LAND)) continue;
            if (cardTypes.isEmpty()) {
                cardTypes.addAll(card.getCardTypeForDeckbuilding());
                continue;
            }
            cardTypes.retainAll(card.getCardTypeForDeckbuilding());
            if (!cardTypes.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

