/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnbreathingHordeEntersEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter1 = new FilterCreaturePermanent();
    private static final FilterCreatureCard filter2 = new FilterCreatureCard();

    public UnbreathingHordeEntersEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} enters with a +1/+1 counter on it for each other Zombie you control and each Zombie card in your graveyard";
    }

    private UnbreathingHordeEntersEffect(UnbreathingHordeEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && player != null) {
            int amount = game.getBattlefield().countAll((FilterPermanent)filter1, source.getControllerId(), game);
            if ((amount += player.getGraveyard().count((FilterCard)filter2, game)) > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public UnbreathingHordeEntersEffect copy() {
        return new UnbreathingHordeEntersEffect(this);
    }

    static {
        filter1.add((Predicate)SubType.ZOMBIE.getPredicate());
        filter2.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

