/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class UnconventionalTacticsTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Zombie");

    public UnconventionalTacticsTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new DoIfCostPaid((Effect)new ReturnToHandSourceEffect(), (Cost)new ManaCostsImpl("{W}")), false);
    }

    private UnconventionalTacticsTriggeredAbility(UnconventionalTacticsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UnconventionalTacticsTriggeredAbility copy() {
        return new UnconventionalTacticsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.controllerId) && filter.match((Object)permanent, game);
    }

    public String getRule() {
        return "Whenever a Zombie you control enters, you may pay {W}. If you do, return {this} from your graveyard to your hand.";
    }

    static {
        filter.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

