/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.other.PlayerWithTheMostLifePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class UndercoverButlerAbility
extends TriggeredAbilityImpl {
    UndercoverButlerAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CantBeBlockedSourceEffect(Duration.EndOfTurn), false);
        this.setTriggerPhrase("Whenever {this} attacks the player with the most life or tied for most life, ");
    }

    private UndercoverButlerAbility(UndercoverButlerAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UndercoverButlerAbility copy() {
        return new UndercoverButlerAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defenderId = game.getCombat().getDefenderId(this.getSourceId());
        if (defenderId == null) {
            return false;
        }
        Player attackedPlayer = game.getPlayer(defenderId);
        return PlayerWithTheMostLifePredicate.instance.apply(new ObjectSourcePlayer((Object)attackedPlayer, this.getControllerId(), null), game);
    }
}

