/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.events.GameEvent;

class UnderrealmLichReplacementEffect
extends ReplacementEffectImpl {
    UnderrealmLichReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, instead look at the top three cards of your library, then put one into your hand and the rest into your graveyard.";
    }

    private UnderrealmLichReplacementEffect(UnderrealmLichReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public UnderrealmLichReplacementEffect copy() {
        return new UnderrealmLichReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        new LookLibraryAndPickControllerEffect(3, 1, PutCards.HAND, PutCards.GRAVEYARD).apply(game, source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

