/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UndyingFlamesEffect
extends OneShotEffect {
    UndyingFlamesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile cards from the top of your library until you exile a nonland card. {this} deals damage to any target equal to that card's mana value";
    }

    private UndyingFlamesEffect(UndyingFlamesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            while (controller.canRespond() && controller.getLibrary().hasCards()) {
                Card card = controller.getLibrary().getFromTop(game);
                if (card == null) continue;
                controller.moveCards(card, Zone.EXILED, source, game);
                if (card.isLand(game)) continue;
                new DamageTargetEffect(card.getManaValue()).apply(game, source);
                break;
            }
            return true;
        }
        return false;
    }

    public UndyingFlamesEffect copy() {
        return new UndyingFlamesEffect(this);
    }
}

