/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.u.UnexpectedRequestUnattachEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class UnexpectedRequestAttachEffect
extends OneShotEffect {
    UnexpectedRequestAttachEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may attach an Equipment you control to that creature. If you do, unattach it at the beginning of the next end step";
    }

    private UnexpectedRequestAttachEffect(UnexpectedRequestAttachEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnexpectedRequestAttachEffect copy() {
        return new UnexpectedRequestAttachEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null || !game.getBattlefield().contains(StaticFilters.FILTER_CONTROLLED_PERMANENT_EQUIPMENT, source.getControllerId(), source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, StaticFilters.FILTER_CONTROLLED_PERMANENT_EQUIPMENT, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent equipment = game.getPermanent(target.getFirstTarget());
        if (equipment == null || !permanent.addAttachment(equipment.getId(), source, game)) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new UnexpectedRequestUnattachEffect(equipment, game)), source);
        return true;
    }
}

