/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnifiedStrikeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    UnifiedStrikeEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target attacking creature if its power is less than or equal to the number of Soldiers on the battlefield";
    }

    private UnifiedStrikeEffect(UnifiedStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnifiedStrikeEffect copy() {
        return new UnifiedStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean successful;
        Permanent creature = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (creature == null || player == null) {
            return false;
        }
        int soldierCount = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).size();
        boolean bl = successful = creature.getPower().getValue() <= soldierCount;
        if (successful) {
            player.moveCards((Card)creature, Zone.EXILED, source, game);
        }
        return successful;
    }

    static {
        filter.add((Predicate)SubType.SOLDIER.getPredicate());
    }
}

