/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.StackObject;

class UnifiedWillEffect
extends OneShotEffect {
    UnifiedWillEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if you control more creatures than that spell's controller";
    }

    private UnifiedWillEffect(UnifiedWillEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        if (stackObject != null) {
            if (game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game) > game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, stackObject.getControllerId(), game)) {
                return game.getStack().counter(source.getFirstTarget(), source, game);
            }
            return true;
        }
        return false;
    }

    public UnifiedWillEffect copy() {
        return new UnifiedWillEffect(this);
    }
}

