/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.u.UnluckyWitnessPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UnluckyWitnessEffect
extends OneShotEffect {
    UnluckyWitnessEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top two cards of your library. Until your next end step, you may play one of those cards";
    }

    private UnluckyWitnessEffect(UnluckyWitnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnluckyWitnessEffect copy() {
        return new UnluckyWitnessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new UnluckyWitnessPlayEffect((Cards)cards, game), source);
        return true;
    }
}

