/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnnaturalHungerEffect
extends OneShotEffect {
    UnnaturalHungerEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals damage to that player equal to that creature's power unless they sacrifice another creature";
    }

    private UnnaturalHungerEffect(UnnaturalHungerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attachedTo;
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura != null && (attachedTo = game.getPermanent(aura.getAttachedTo())) != null) {
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(aura.getAttachedTo())));
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)filter);
            Player enchantedCreatureController = game.getPlayer(attachedTo.getControllerId());
            if (enchantedCreatureController == null || !cost.canPay(source, source, enchantedCreatureController.getId(), game) || !enchantedCreatureController.chooseUse(this.outcome, "Sacrifice another creature to prevent " + attachedTo.getPower().getValue() + " damage?", source, game) || cost.pay(source, game, source, enchantedCreatureController.getId(), true)) {
                // empty if block
            }
            if (enchantedCreatureController != null && !cost.isPaid()) {
                enchantedCreatureController.damage(attachedTo.getPower().getValue(), source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public UnnaturalHungerEffect copy() {
        return new UnnaturalHungerEffect(this);
    }
}

