/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.stack.Spell;

class UnravelEffect
extends OneShotEffect {
    UnravelEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. If the amount of mana spent to cast that spell was less than its mana value, you draw a card";
    }

    private UnravelEffect(UnravelEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnravelEffect copy() {
        return new UnravelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        boolean flag = spell.getStackAbility().getManaCostsToPay().getUsedManaToPay().count() < spell.getManaValue();
        game.getStack().counter(spell.getId(), source, game);
        if (!flag) {
            return true;
        }
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(1, source, game));
        return true;
    }
}

