/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnrulyKrasisEffect
extends OneShotEffect {
    UnrulyKrasisEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "have the base power and toughness of another target creature you control become X/X until end of turn, where X is {this}'s power";
    }

    private UnrulyKrasisEffect(UnrulyKrasisEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnrulyKrasisEffect copy() {
        return new UnrulyKrasisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        int xValue = permanent.getPower().getValue();
        SetBasePowerToughnessTargetEffect effect = new SetBasePowerToughnessTargetEffect(xValue, xValue, Duration.EndOfTurn);
        effect.setTargetPointer(this.getTargetPointer().copy());
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

