/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class UnshakableTailInvestigateTriggeredAbility
extends TriggeredAbilityImpl {
    UnshakableTailInvestigateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InvestigateEffect(), false);
        this.setTriggerPhrase("Whenever one or more creature cards are put into your graveyard from your library, ");
    }

    private UnshakableTailInvestigateTriggeredAbility(UnshakableTailInvestigateTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.LIBRARY == zEvent.getFromZone() && Zone.GRAVEYARD == zEvent.getToZone() && zEvent.getCards() != null) {
            for (Card card : zEvent.getCards()) {
                UUID cardOwnerId;
                if (card == null || (cardOwnerId = card.getOwnerId()) == null || !card.isOwnedBy(this.getControllerId()) || !card.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }

    public UnshakableTailInvestigateTriggeredAbility copy() {
        return new UnshakableTailInvestigateTriggeredAbility(this);
    }
}

