/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenControllerTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DetectiveToken;
import mage.game.permanent.token.Token;

class UnyieldingGatekeeperEffect
extends OneShotEffect {
    UnyieldingGatekeeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile another target nonland permanent. If you controlled it, return it to the battlefield tapped. Otherwise, its controller creates a 2/2 white and blue Detective creature token";
    }

    private UnyieldingGatekeeperEffect(UnyieldingGatekeeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.isControlledBy(source.getControllerId())) {
            new ExileThenReturnTargetEffect(false, false, PutCards.BATTLEFIELD_TAPPED).apply(game, source);
        } else {
            new ExileTargetEffect().apply(game, source);
            new CreateTokenControllerTargetEffect((Token)new DetectiveToken()).apply(game, source);
        }
        return true;
    }

    public UnyieldingGatekeeperEffect copy() {
        return new UnyieldingGatekeeperEffect(this);
    }
}

