/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UrdnanDromokaWarriorEffect
extends OneShotEffect {
    UrdnanDromokaWarriorEffect() {
        super(Outcome.Benefit);
        this.staticText = "target attacking creature with a +1/+1 counter on it gains first strike until end of turn. If that creature has two or more +1/+1 counters on it, it gains double strike until end of turn instead";
    }

    private UrdnanDromokaWarriorEffect(UrdnanDromokaWarriorEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrdnanDromokaWarriorEffect copy() {
        return new UrdnanDromokaWarriorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)(permanent.getCounters(game).getCount(CounterType.P1P1) >= 2 ? DoubleStrikeAbility.getInstance() : FirstStrikeAbility.getInstance())).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

