/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class UrgeToFeedEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("untapped Vampire creatures you control");

    public UrgeToFeedEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "You may tap any number of untapped Vampire creatures you control. If you do, put a +1/+1 counter on each of those Vampires";
    }

    private UrgeToFeedEffect(UrgeToFeedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        target.choose(Outcome.Tap, source.getControllerId(), source.getSourceId(), source, game);
        for (UUID vampireId : target.getTargets()) {
            Permanent vampire = game.getPermanent(vampireId);
            if (vampire == null) continue;
            vampire.tap(source, game);
            vampire.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }

    public UrgeToFeedEffect copy() {
        return new UrgeToFeedEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)SubType.VAMPIRE.getPredicate());
    }
}

