/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.MayLookAtTargetCardEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class UriangerAugureltExileEffect
extends OneShotEffect {
    UriangerAugureltExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. You may exile it face down";
    }

    private UriangerAugureltExileEffect(UriangerAugureltExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public UriangerAugureltExileEffect copy() {
        return new UriangerAugureltExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (!player.chooseUse(Outcome.DrawCard, "Exile " + card.getLogName() + " face down?", source, game)) {
            return false;
        }
        player.moveCardsToExile(card, source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        card.setFaceDown(true, game);
        game.addEffect(new MayLookAtTargetCardEffect(source.getControllerId()).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }
}

