/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class UrzaAcademyHeadmasterBrainstormEffect
extends OneShotEffect {
    UrzaAcademyHeadmasterBrainstormEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw three cards, then put a card from your hand on top of your library";
    }

    private UrzaAcademyHeadmasterBrainstormEffect(UrzaAcademyHeadmasterBrainstormEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzaAcademyHeadmasterBrainstormEffect copy() {
        return new UrzaAcademyHeadmasterBrainstormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(3, source, game);
            this.putOnLibrary(player, source, game);
            return true;
        }
        return false;
    }

    private boolean putOnLibrary(Player player, Ability source, Game game) {
        TargetCardInHand target = new TargetCardInHand();
        if (target.canChoose(player.getId(), source, game)) {
            player.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            Card card = player.getHand().get(target.getFirstTarget(), game);
            if (card != null) {
                return player.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
            }
        }
        return false;
    }
}

