/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.cost.SpellsCostReductionControllerEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardSetInfo;
import mage.cards.MeldCard;
import mage.cards.u.UrzaPlaneswalkerEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.SoldierArtifactToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;

public final class UrzaPlaneswalker
extends MeldCard {
    private static final FilterCard filter = new FilterCard("Artifact, instant, and sorcery spells you cast this turn");
    private static final FilterPermanent filter2 = new FilterPermanent("artifacts and planeswalkers");

    public UrzaPlaneswalker(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.URZA);
        this.setStartingLoyalty(7);
        this.color.setWhite(true);
        this.color.setBlue(true);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new UrzaPlaneswalkerEffect()));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new SpellsCostReductionControllerEffect(filter, 2).setDuration(Duration.EndOfTurn), 2);
        ability.addEffect((Effect)new GainLifeEffect(2));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DrawDiscardControllerEffect(2, 1), 1));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new SoldierArtifactToken(), 2), 0));
        ability = new LoyaltyAbility((Effect)new ExileTargetEffect(), -3);
        ability.addTarget((Target)new TargetNonlandPermanent());
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, filter2), -10);
        ability.addEffect((Effect)new DestroyAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENTS_NON_LAND));
        this.addAbility((Ability)ability);
    }

    private UrzaPlaneswalker(UrzaPlaneswalker card) {
        super((MeldCard)card);
    }

    public UrzaPlaneswalker copy() {
        return new UrzaPlaneswalker(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()}));
        filter2.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

