/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class UrzasChaliceAbility
extends TriggeredAbilityImpl {
    public UrzasChaliceAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new GainLifeEffect(1), (Cost)new GenericManaCost(1)), false);
    }

    private UrzasChaliceAbility(UrzasChaliceAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UrzasChaliceAbility copy() {
        return new UrzasChaliceAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.isArtifact(game);
    }

    public String getRule() {
        return "Whenever a player casts an artifact spell, you may pay {1}. If you do, you gain 1 life.";
    }
}

