/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.Card;
import mage.cards.u.UrzasHotTubPredicate;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class UrzasHotTubEffect
extends OneShotEffect {
    UrzasHotTubEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Search your library for a card that shares a complete word in its name with the discarded card, reveal it, put it into your hand, then shuffle";
    }

    private UrzasHotTubEffect(UrzasHotTubEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzasHotTubEffect copy() {
        return new UrzasHotTubEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            DiscardTargetCost discardCost;
            Card discardedCard;
            if (!(cost instanceof DiscardTargetCost) || (discardedCard = (Card)(discardCost = (DiscardTargetCost)cost).getCards().get(0)) == null) continue;
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new UrzasHotTubPredicate(discardedCard.getName()));
            return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true).apply(game, source);
        }
        return false;
    }
}

