/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventCombatDamageBySourceEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class UrzasScienceFairProjectEffect
extends OneShotEffect {
    UrzasScienceFairProjectEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll a six-sided die. {this} gets the indicated result.<br>1 - It gets -2/-2 until end of turn.<br>2 - Prevent all combat damage it would deal this turn.<br>3 - It gains vigilance until end of turn.<br>4 - It gains first strike until end of turn.<br>5 - It gains flying until end of turn.<br>6 - It gets +2/+2 until end of turn";
    }

    private UrzasScienceFairProjectEffect(UrzasScienceFairProjectEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzasScienceFairProjectEffect copy() {
        return new UrzasScienceFairProjectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PreventCombatDamageBySourceEffect effect;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = controller.rollDice(this.outcome, source, game, 6);
        switch (amount) {
            case 1: {
                effect = new BoostSourceEffect(-2, -2, Duration.EndOfTurn);
                break;
            }
            case 2: {
                effect = new PreventCombatDamageBySourceEffect(Duration.EndOfTurn);
                break;
            }
            case 3: {
                effect = new GainAbilitySourceEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn);
                break;
            }
            case 4: {
                effect = new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
                break;
            }
            case 5: {
                effect = new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
                break;
            }
            case 6: {
                effect = new BoostSourceEffect(2, 2, Duration.EndOfTurn);
                break;
            }
            default: {
                return true;
            }
        }
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

