/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.HistoricPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class UrzasTomeEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a historic card");

    UrzasTomeEffect() {
        super(Outcome.Discard);
        this.staticText = "Then discard a card unless you exile a historic card from your graveyard";
    }

    private UrzasTomeEffect(UrzasTomeEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzasTomeEffect copy() {
        return new UrzasTomeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ExileFromGraveCost cost;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.chooseUse(Outcome.Exile, "Exile a historic card from your graveyard?", source, game) && (cost = new ExileFromGraveCost(new TargetCardInYourGraveyard(filter))).canPay(source, source, controller.getId(), game) && cost.pay(source, game, source, controller.getId(), false, null)) {
            return true;
        }
        controller.discard(1, false, false, source, game);
        return true;
    }

    static {
        filter.add((Predicate)HistoricPredicate.instance);
    }
}

