/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UtopiaSprawlEffect
extends ManaEffect {
    UtopiaSprawlEffect() {
        this.staticText = "its controller adds an additional one mana of the chosen color";
    }

    private UtopiaSprawlEffect(UtopiaSprawlEffect effect) {
        super((ManaEffect)effect);
    }

    public Player getPlayer(Game game, Ability source) {
        Permanent land;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && (land = game.getPermanent(enchantment.getAttachedTo())) != null) {
            return game.getPlayer(land.getControllerId());
        }
        return null;
    }

    public Mana produceMana(Game game, Ability source) {
        ObjectColor color;
        if (game != null && (color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color")) != null) {
            return new Mana(ColoredManaSymbol.lookup((char)color.toString().charAt(0)));
        }
        return new Mana();
    }

    public UtopiaSprawlEffect copy() {
        return new UtopiaSprawlEffect(this);
    }
}

