/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.Card;
import mage.cards.u.UvildaDeanOfPerfectionCondition;
import mage.cards.u.UvildaDeanOfPerfectionTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class UvildaDeanOfPerfectionGainAbilityEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;

    UvildaDeanOfPerfectionGainAbilityEffect(Card card, Game game) {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.mor = new MageObjectReference((MageObject)card, game);
    }

    private UvildaDeanOfPerfectionGainAbilityEffect(UvildaDeanOfPerfectionGainAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.mor = effect.mor;
    }

    public UvildaDeanOfPerfectionGainAbilityEffect copy() {
        return new UvildaDeanOfPerfectionGainAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = this.mor.getCard(game);
        if (card == null) {
            this.discard();
            return true;
        }
        Object ability = new BeginningOfUpkeepTriggeredAbility(Zone.EXILED, TargetController.YOU, (Effect)new RemoveCounterSourceEffect(CounterType.HONE.createInstance()).setText("remove a hone counter from it"), false).withInterveningIf((Condition)UvildaDeanOfPerfectionCondition.instance);
        ability.setSourceId(card.getId());
        ability.setControllerId(source.getControllerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        ability = new UvildaDeanOfPerfectionTriggeredAbility();
        ability.setSourceId(card.getId());
        ability.setControllerId(source.getControllerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }
}

