/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class VaevictisAsmadiTheDireEffect
extends OneShotEffect {
    VaevictisAsmadiTheDireEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "for each player, choose target permanent that player controls. Those players sacrifice those permanents. Each player who sacrificed a permanent this way reveals the top card of their library, then puts it onto the battlefield if it's a permanent card";
    }

    private VaevictisAsmadiTheDireEffect(VaevictisAsmadiTheDireEffect effect) {
        super((OneShotEffect)effect);
    }

    public VaevictisAsmadiTheDireEffect copy() {
        return new VaevictisAsmadiTheDireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Player> playersToFlip = new ArrayList<Player>();
        for (Target target : source.getTargets()) {
            for (UUID permId : target.getTargets()) {
                Player player;
                Permanent permanent = game.getPermanent(permId);
                if (permanent == null || !permanent.sacrifice(source, game) || (player = game.getPlayer(permanent.getControllerId())) == null) continue;
                playersToFlip.add(player);
            }
        }
        for (Player player : playersToFlip) {
            if (player == null) {
                return false;
            }
            Card card = player.getLibrary().getFromTop(game);
            if (card == null) continue;
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            if (!card.isPermanent(game)) continue;
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

