/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.v.ValakutTheMoltenPinnacle;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class ValakutTheMoltenPinnacleTriggeredAbility
extends TriggeredAbilityImpl {
    ValakutTheMoltenPinnacleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(3), true);
        this.addTarget((Target)new TargetAnyTarget());
    }

    private ValakutTheMoltenPinnacleTriggeredAbility(ValakutTheMoltenPinnacleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().count((FilterPermanent)ValakutTheMoltenPinnacle.filter, this.getControllerId(), (Ability)this, game) > 5;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.MOUNTAIN, game);
    }

    public ValakutTheMoltenPinnacleTriggeredAbility copy() {
        return new ValakutTheMoltenPinnacleTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a Mountain you control enters, if you control at least five other Mountains, you may have {this} deal 3 damage to any target.";
    }
}

