/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Pest11GainLifeToken;
import mage.game.permanent.token.Token;

class ValentinDeanOfTheVeinEffect
extends ReplacementEffectImpl {
    ValentinDeanOfTheVeinEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "if a nontoken creature an opponent controls would die, exile it instead. When you do, you may pay {2}. If you do, create a 1/1 black and green Pest creature token with \"When this creature dies, you gain 1 life.\"";
    }

    private ValentinDeanOfTheVeinEffect(ValentinDeanOfTheVeinEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ValentinDeanOfTheVeinEffect copy() {
        return new ValentinDeanOfTheVeinEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new DoIfCostPaid((Effect)new CreateTokenEffect((Token)new Pest11GainLifeToken()), (Cost)new GenericManaCost(2)), false, "you may pay {2}. If you do, create a 1/1 black and green Pest creature token with \"When this creature dies, you gain 1 life.\""), source);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget() != null && !(zEvent.getTarget() instanceof PermanentToken) && zEvent.getTarget().isCreature(game) && game.getOpponents(zEvent.getTarget().getControllerId()).contains(source.getControllerId());
    }
}

