/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.ArrayList;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestDreadEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ValgavothsOnslaughtEffect
extends OneShotEffect {
    ValgavothsOnslaughtEffect() {
        super(Outcome.Benefit);
        this.staticText = "manifest dread X times, then put X +1/+1 counters on each of those creatures";
    }

    private ValgavothsOnslaughtEffect(ValgavothsOnslaughtEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValgavothsOnslaughtEffect copy() {
        return new ValgavothsOnslaughtEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || amount < 1) {
            return false;
        }
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        for (int i = 0; i < amount; ++i) {
            permanents.add(ManifestDreadEffect.doManifestDread((Player)player, (Ability)source, (Game)game));
            game.processAction();
        }
        permanents.removeIf(Objects::isNull);
        for (Permanent permanent : permanents) {
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source, game);
        }
        return true;
    }
}

