/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ValkiGodOfLiesCopyExiledEffect
extends OneShotEffect {
    ValkiGodOfLiesCopyExiledEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature card exiled with {this} with mana value X. {this} becomes a copy of that card.";
    }

    private ValkiGodOfLiesCopyExiledEffect(ValkiGodOfLiesCopyExiledEffect effect) {
        super((OneShotEffect)effect);
    }

    public ValkiGodOfLiesCopyExiledEffect copy() {
        return new ValkiGodOfLiesCopyExiledEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject Valki = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && Valki != null) {
            Card chosenExiledCard;
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
            TargetCardInExile target = new TargetCardInExile(filter, exileId);
            ExileZone cards = game.getExile().getExileZone(exileId);
            if (cards != null && !cards.isEmpty() && controller.choose(Outcome.Benefit, (Cards)cards, (TargetCard)target, source, game) && (chosenExiledCard = game.getCard(target.getFirstTarget())) != null) {
                CopyEffect copyEffect = new CopyEffect(Duration.WhileOnBattlefield, (MageObject)chosenExiledCard.getMainCard(), source.getSourceId());
                copyEffect.setTargetPointer((TargetPointer)new FixedTarget(Valki.getId(), game));
                game.addEffect((ContinuousEffect)copyEffect, source);
                return true;
            }
        }
        return false;
    }
}

